/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.debugger;

import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.gct.idea.debugger.CloudDebugProcessState;
import com.google.gct.idea.debugger.CloudDebugProcessStateSerializer;
import com.google.gct.idea.debugger.CloudDebugProcessWatcher;
import com.google.gct.idea.debugger.CloudDebugSettingsEditor;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.ModuleRunConfiguration;
import com.intellij.execution.configurations.RemoteRunProfile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationWithSuppressedDefaultDebugAction;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudDebugRunConfiguration
extends LocatableConfigurationBase
implements ModuleRunConfiguration,
RunConfigurationWithSuppressedDefaultDebugAction,
RunConfigurationWithSuppressedDefaultRunAction,
RemoteRunProfile {
    private static final String NAME = "Cloud Debug Configuration";
    private static final String PROJECT_NAME_TAG = "CloudProjectName";
    private static final String SHOW_NOTIFICATIONS = "CloudShowNotify";
    private String myCloudProjectName;
    private volatile CloudDebugProcessState myProcessState;
    private boolean myShowNotifications;

    protected CloudDebugRunConfiguration(Project project, @NotNull ConfigurationFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/google/gct/idea/debugger/CloudDebugRunConfiguration", "<init>"));
        }
        super(project, factory, NAME);
        this.myProcessState = null;
        this.myShowNotifications = true;
        CloudDebugProcessWatcher.getInstance().ensureWatcher();
    }

    public final RunConfiguration clone() {
        CloudDebugRunConfiguration configuration = (CloudDebugRunConfiguration)super.clone();
        configuration.setCloudProjectName(this.getCloudProjectName());
        configuration.setShowNotifications(this.isShowNotifications());
        return configuration;
    }

    @Nullable
    public String getCloudProjectName() {
        return this.myCloudProjectName;
    }

    public void setCloudProjectName(@Nullable String cloudProjectName) {
        this.myCloudProjectName = cloudProjectName;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        CloudDebugSettingsEditor cloudDebugSettingsEditor = new CloudDebugSettingsEditor();
        if (cloudDebugSettingsEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/idea/debugger/CloudDebugRunConfiguration", "getConfigurationEditor"));
        }
        return cloudDebugSettingsEditor;
    }

    @NotNull
    public Module[] getModules() {
        if (Module.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/idea/debugger/CloudDebugRunConfiguration", "getModules"));
        }
        return Module.EMPTY_ARRAY;
    }

    @Nullable
    public CloudDebugProcessState getProcessState() {
        return this.myProcessState;
    }

    public void setProcessState(@Nullable CloudDebugProcessState processState) {
        this.myProcessState = processState;
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/google/gct/idea/debugger/CloudDebugRunConfiguration", "getState"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/google/gct/idea/debugger/CloudDebugRunConfiguration", "getState"));
        }
        if (this.myProcessState == null) {
            return new CloudDebugProcessState(null, null, this.myCloudProjectName, null, this.getProject());
        }
        return this.myProcessState;
    }

    public boolean isShowNotifications() {
        return this.myShowNotifications;
    }

    public void setShowNotifications(boolean showNotifications) {
        this.myShowNotifications = showNotifications;
    }

    public void readExternal(Element element) throws InvalidDataException {
        Attribute showNotificationsAttribute;
        super.readExternal(element);
        Attribute projectNameAttribute = element.getAttribute(PROJECT_NAME_TAG);
        if (projectNameAttribute != null) {
            this.myCloudProjectName = projectNameAttribute.getValue();
        }
        if ((showNotificationsAttribute = element.getAttribute(SHOW_NOTIFICATIONS)) != null) {
            this.myShowNotifications = Boolean.valueOf(showNotificationsAttribute.getValue());
        }
        if (!Strings.isNullOrEmpty((String)this.myCloudProjectName) && !Strings.isNullOrEmpty((String)this.getName())) {
            this.myProcessState = CloudDebugProcessStateSerializer.getInstance(this.getProject()).getState(this.getName(), this.myCloudProjectName);
        }
        CloudDebugProcessWatcher.getInstance().ensureWatcher();
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        element.setAttribute(PROJECT_NAME_TAG, this.myCloudProjectName == null ? "" : this.myCloudProjectName);
        element.setAttribute(SHOW_NOTIFICATIONS, Boolean.toString(this.myShowNotifications));
    }
}

