/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.debugger;

import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.api.services.debugger.Debugger;
import com.google.api.services.debugger.model.Breakpoint;
import com.google.api.services.debugger.model.ListBreakpointsResponse;
import com.google.gct.idea.debugger.BreakpointComparer;
import com.google.gct.idea.debugger.CloudBreakpointListener;
import com.google.gct.idea.debugger.CloudDebugProcessState;
import com.google.gct.idea.debugger.CloudDebugRunConfiguration;
import com.google.gct.idea.debugger.CloudDebuggerClient;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.jetbrains.annotations.NotNull;

public class CloudDebugGlobalPoller {
    private static final int DELAY_MS = 10000;
    private static final Logger LOG = Logger.getInstance(CloudDebugGlobalPoller.class);
    private final List<CloudBreakpointListener> myBreakpointListChangedListeners = new ArrayList<CloudBreakpointListener>();
    private Timer myWatchTimer = null;

    public void addListener(@NotNull CloudBreakpointListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/google/gct/idea/debugger/CloudDebugGlobalPoller", "addListener"));
        }
        this.myBreakpointListChangedListeners.add(listener);
    }

    public void removeListener(@NotNull CloudBreakpointListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/google/gct/idea/debugger/CloudDebugGlobalPoller", "removeListener"));
        }
        this.myBreakpointListChangedListeners.remove(listener);
    }

    public synchronized void startBackgroundListening() {
        if (this.myWatchTimer == null) {
            this.myWatchTimer = new Timer("cloud debug watcher");
            this.myWatchTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    for (CloudDebugProcessState state : CloudDebugGlobalPoller.getStates()) {
                        CloudDebugGlobalPoller.this.pollForChanges(state);
                    }
                }
            }, 10000L, 10000L);
            ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new ApplicationAdapter(){

                public void applicationExiting() {
                    CloudDebugGlobalPoller.this.myWatchTimer.cancel();
                }
            });
        }
    }

    private static List<CloudDebugProcessState> getStates() {
        ArrayList<CloudDebugProcessState> states = new ArrayList<CloudDebugProcessState>();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            HashSet<RunProfile> debuggingProfiles = new HashSet<RunProfile>();
            XDebuggerManager debugManager = XDebuggerManager.getInstance((Project)project);
            for (XDebugSession session : debugManager.getDebugSessions()) {
                if (session.isStopped() || session.getRunProfile() == null) continue;
                debuggingProfiles.add(session.getRunProfile());
            }
            RunManager manager = RunManager.getInstance((Project)project);
            for (RunnerAndConfigurationSettings config : manager.getAllSettings()) {
                CloudDebugProcessState state;
                CloudDebugRunConfiguration cloudConfig;
                if (config.getConfiguration() == null || debuggingProfiles.contains(config.getConfiguration()) || !(config.getConfiguration() instanceof CloudDebugRunConfiguration) || !(cloudConfig = (CloudDebugRunConfiguration)config.getConfiguration()).isShowNotifications() || (state = cloudConfig.getProcessState()) == null) continue;
                states.add(state);
            }
        }
        return states;
    }

    private static void queryServerForBreakpoints(CloudDebugProcessState state, Debugger client) throws IOException {
        ListBreakpointsResponse response = (ListBreakpointsResponse)client.debuggees().breakpoints().list(state.getDebuggeeId()).setIncludeInactive(Boolean.TRUE).setAction("CAPTURE").setStripResults(Boolean.TRUE).setWaitToken(null).execute();
        List currentList = response.getBreakpoints();
        String responseWaitToken = response.getWaitToken();
        state.setWaitToken(responseWaitToken);
        if (currentList != null) {
            Collections.sort(currentList, BreakpointComparer.getDefaultInstance());
        }
        state.setCurrentServerBreakpointList((ImmutableList<Breakpoint>)(currentList != null ? ContainerUtil.immutableList((List)currentList) : ContainerUtil.immutableList(new ArrayList())));
    }

    private void fireBreakpointsChanged(@NotNull CloudDebugProcessState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/google/gct/idea/debugger/CloudDebugGlobalPoller", "fireBreakpointsChanged"));
        }
        for (CloudBreakpointListener listener : this.myBreakpointListChangedListeners) {
            listener.onBreakpointListChanged(state);
        }
    }

    private void pollForChanges(@NotNull CloudDebugProcessState state) {
        boolean changed;
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/google/gct/idea/debugger/CloudDebugGlobalPoller", "pollForChanges"));
        }
        Debugger client = CloudDebuggerClient.getCloudDebuggerClient(state);
        if (client == null) {
            LOG.info("no client available attempting to checkForChanges");
            return;
        }
        try {
            String oldToken = state.getWaitToken();
            CloudDebugGlobalPoller.queryServerForBreakpoints(state, client);
            String responseWaitToken = state.getWaitToken();
            if (!Strings.isNullOrEmpty((String)responseWaitToken)) {
                assert (responseWaitToken != null);
                changed = oldToken == null || !responseWaitToken.equals(oldToken);
            } else {
                changed = !Strings.isNullOrEmpty((String)oldToken);
            }
        }
        catch (IOException ex) {
            LOG.warn("exception listing breakpoints", (Throwable)ex);
            return;
        }
        if (changed) {
            this.fireBreakpointsChanged(state);
        }
    }
}

